/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.PostgreSQLFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b \u0010!J\u0017\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J/\u0010\t\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0005J\u001b\u0010\u000f\u001a\u00020\u000e2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J)\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u000e8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006#"}, d2={"Lorg/jetbrains/exposed/sql/vendors/PostgreSQLDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "", "name", "createDatabase", "(Ljava/lang/String;)Ljava/lang/String;", "table", "columns", "type", "createIndexWithType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "dropDatabase", "Lorg/jetbrains/exposed/sql/Expression;", "e", "", "isAllowedAsColumnDefault", "(Lorg/jetbrains/exposed/sql/Expression;)Z", "Lorg/jetbrains/exposed/sql/Column;", "column", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "columnDiff", "", "modifyColumn", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/ColumnDiff;)Ljava/util/List;", "Lorg/jetbrains/exposed/sql/Schema;", "schema", "setSchema", "(Lorg/jetbrains/exposed/sql/Schema;)Ljava/lang/String;", "supportsOrderByNullsFirstLast", "Z", "getSupportsOrderByNullsFirstLast", "()Z", "<init>", "()V", "Companion", "exposed-core"})
public class PostgreSQLDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsOrderByNullsFirstLast;
    @NotNull
    public static final String dialectName = "postgresql";

    public PostgreSQLDialect() {
        super(dialectName, PostgreSQLDataTypeProvider.INSTANCE, PostgreSQLFunctionProvider.INSTANCE);
        this.supportsOrderByNullsFirstLast = true;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return true;
    }

    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"columnDiff");
        StringBuilder $this$modifyColumn_u24lambda_u2d2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Transaction tr = TransactionManager.Companion.current();
        $this$modifyColumn_u24lambda_u2d2.append("ALTER TABLE " + tr.identity(column.getTable()) + ' ');
        String colName = tr.identity(column);
        $this$modifyColumn_u24lambda_u2d2.append("ALTER COLUMN " + colName + " TYPE " + column.getColumnType().sqlType());
        if (columnDiff.getNullability()) {
            $this$modifyColumn_u24lambda_u2d2.append(", ALTER COLUMN " + colName + ' ');
            if (column.getColumnType().getNullable()) {
                $this$modifyColumn_u24lambda_u2d2.append("DROP ");
            } else {
                $this$modifyColumn_u24lambda_u2d2.append("SET ");
            }
            $this$modifyColumn_u24lambda_u2d2.append("NOT NULL");
        }
        if (columnDiff.getDefaults()) {
            StringBuilder stringBuilder2;
            Expression<?> expression = column.getDbDefaultValue$exposed_core();
            if (expression == null) {
                stringBuilder2 = null;
            } else {
                Expression<?> it = expression;
                boolean bl2 = false;
                stringBuilder2 = $this$modifyColumn_u24lambda_u2d2.append(", ALTER COLUMN " + colName + " SET DEFAULT " + PostgreSQLDataTypeProvider.INSTANCE.processForDefaultValue(it));
            }
            StringBuilder stringBuilder3 = stringBuilder2;
            if (stringBuilder3 == null) {
                StringBuilder $this$modifyColumn_u24lambda_u2d2_u24lambda_u2d1 = $this$modifyColumn_u24lambda_u2d2;
                boolean bl3 = false;
                String cfr_ignored_0 = ",  ALTER COLUMN " + colName + " DROP DEFAULT";
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return CollectionsKt.listOf((Object)string);
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Intrinsics.stringPlus((String)"CREATE DATABASE ", (Object)DefaultKt.inProperCase(name));
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Intrinsics.stringPlus((String)"DROP DATABASE ", (Object)DefaultKt.inProperCase(name));
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return Intrinsics.stringPlus((String)"SET search_path TO ", (Object)schema.getIdentifier());
    }

    @Override
    @NotNull
    protected String createIndexWithType(@NotNull String name, @NotNull String table, @NotNull String columns2, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)columns2, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return "CREATE INDEX " + name + " ON " + table + " USING " + type + ' ' + columns2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/vendors/PostgreSQLDialect$Companion;", "", "", "dialectName", "Ljava/lang/String;", "<init>", "()V", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

